/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    public static ExecRow getEmptyValueRow(int n, LanguageConnectionContext languageConnectionContext) {
        ExecutionContext executionContext = languageConnectionContext.getExecutionContext();
        return executionContext.getExecutionFactory().getValueRow(n);
    }

    public static ExecIndexRow getEmptyIndexRow(int n, ContextManager contextManager) {
        ExecutionContext executionContext = (ExecutionContext)contextManager.getContext("ExecutionContext");
        return executionContext.getExecutionFactory().getIndexableRow(n);
    }

    public static void copyCloneColumns(ExecRow execRow, ExecRow execRow2, int n) {
        int n2 = 1;
        while (n2 <= n) {
            execRow.setColumn(n2, execRow2.cloneColumn(n2));
            ++n2;
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, 0, n);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n, int n2) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, n, n2);
    }

    public static void copyRefColumns(ExecRow execRow, int n, ExecRow execRow2, int n2, int n3) throws StandardException {
        int n4 = 1;
        while (n4 <= n3) {
            execRow.setColumn(n4 + n, execRow2.getColumn(n4 + n2));
            ++n4;
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            execRow.setColumn(n2 + 1, execRow2.getColumn(nArray[n2]));
            ++n2;
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet == null) {
            return;
        }
        int n = execRow.getRowArray().length;
        int n2 = 1;
        int n3 = 1;
        while (n2 <= n) {
            if (formatableBitSet.get(n2)) {
                execRow.setColumn(n2, execRow2.getColumn(n3));
                ++n3;
            }
            ++n2;
        }
    }

    public static void copyRefColumns(ExecRow execRow) throws StandardException {
        int n = 1;
        while (n <= execRow.nColumns()) {
            execRow.setColumn(n, null);
            ++n;
        }
    }

    public static String toString(ExecRow execRow) {
        return "";
    }

    public static String toString(Object[] objectArray) {
        return "";
    }

    public static String toString(ExecRow execRow, int n, int n2) {
        return RowUtil.toString(execRow.getRowArray(), n, n2);
    }

    public static String toString(Object[] objectArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n3 = n;
        while (n3 <= n2) {
            if (n3 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[n3]);
            ++n3;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toString(ExecRow execRow, int[] nArray) {
        return RowUtil.toString(execRow.getRowArray(), nArray);
    }

    public static String toString(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[nArray[n] - 1]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static boolean inAscendingOrder(int[] nArray) {
        if (nArray != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n > nArray[n2]) {
                    return false;
                }
                n = nArray[n2];
                ++n2;
            }
        }
        return true;
    }

    public static FormatableBitSet shift(FormatableBitSet formatableBitSet, int n) {
        FormatableBitSet formatableBitSet2 = null;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.size();
            formatableBitSet2 = new FormatableBitSet(n2);
            int n3 = n;
            while (n3 < n2) {
                if (formatableBitSet.get(n3)) {
                    formatableBitSet2.set(n3 - n);
                }
                ++n3;
            }
        }
        return formatableBitSet2;
    }
}

